
public class ElevamentoPotenza 
{
    /*
     * Calcolo della potenza in modo iterativo
     * Prende in input due numeri interi: il numero da elevare e il suo esponente (positivo)
     * il metodo restituisce il valore num^esp
     */
    public int potenzaIterativa(int num, int esp) {
        //se l'esponente e' <= 0, si restituisce 1
        if(esp <= 0)
            return 1;
        int ris = 1;
        for(int i = 0; i < esp; i++)
            ris = ris * num;
        return ris;
    }
    
    /*
     * Calcolo della potenza in modo iterativo
     * Prende in input due numeri interi: il numero da elevare e il suo esponente (positivo)
     * il metodo restituisce il valore num^esp
     * pot(x, e) = x * pot(x, e-1)
     */
    public int potenzaRicorsiva(int num, int esp) {
        if(esp <= 0)
            return 1;
        return num * potenzaRicorsiva(num, esp -1);
    }
    
    /*
     * Calcolo della potenza di un numero. Effettua il calcolo anche per numeri con esponente negativo
     * se l'esponente è negativo, si calcola il risultato con l'esponente positivo e si inverte il risultato
     * num^(-esp) = 1/(num^esp)
     */
    public double potenza(int num, int esp) {
        double ris = 1;
        boolean isNegativo = false;
        //se l'esponente è negativo, si inverte l'esponente
        if(esp<0){
            esp = esp*-1;
            isNegativo = true;
        }
        ris = potenzaRicorsiva(num, esp);
        //se l'esponente era negativo, si deve invertire il risultato
        if(isNegativo)
            ris = 1/ris;
        return ris;
    }
    
}
